#!/bin/sh

TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_OK="DTAS[TUI]@{OK}"
TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE=""

TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG=""

TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP=""
TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME=""
TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_PASSWORD=""

tp_ip_divider_username_password() {
	debug_print "in function '${FUNCNAME[0]}'"
	
	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"
    local ip="${5:-....}"
    local username="${6}"
    local password="${7}"

    local ip_seg_1=`echo "${ip}" | cut -d'.' -f1`
	local ip_seg_2=`echo "${ip}" | cut -d'.' -f2`
	local ip_seg_3=`echo "${ip}" | cut -d'.' -f3`
	local ip_seg_4=`echo "${ip}" | cut -d'.' -f4`

	exec 3>&1	
    local ret=`dialog \
        --backtitle     "${CONS_BACK_TITLE}" \
        --title         "${title}" \
        --ok-label      "${label_ok}" \
        --cancel-label  "${label_cancel}" \
        --insecure      \
        --mixedform     "${text}" \
                        "${CONS_BOX_HEIGHT}" \
                        "${CONS_BOX_WIDTH}" \
                        0 \
        "${STRING_MS_IP}"         1  0 "${ip_seg_1}" 1 31  4  3 0 \
        ""                        1 24 "."           1 35  2  2 2 \
        ""                        1 25 "${ip_seg_2}" 1 36  4  3 0 \
        ""                        1 29 "."           1 40  2  2 2 \
        ""                        1 30 "${ip_seg_3}" 1 41  4  3 0 \
        ""                        1 34 "."           1 45  2  2 2 \
        ""                        1 35 "${ip_seg_4}" 1 46  4  3 0 \
        "---------------------------------------------------------------------" 2 0 "" 2 0 0 0 2 \
        "${STRING_ESXI_USERNAME}" 3  0 "${username}" 3 16 19 18 0 \
        "${STRING_ESXI_PASSWORD}" 5  0 "${password}" 5 16 41 40 1 \
        2>&1 1>&3; \
        case "${?}" in \
            1|255) echo "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL}" ;; \
        esac`
	exec 3>&-

	local msg=`echo "${ret}" | sed -n '1,7p'`
    debug_print "${msg}"

    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL}" )
            TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL}"
            TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG=""
            return
            ;;
    esac

    ##################################################
    # collect user-defined information
    ##################################################
    local input_ip_seg_1=`echo "${ret}" | sed -n '1p' | awk '{print $1}'`
    local input_ip_seg_2=`echo "${ret}" | sed -n '3p' | awk '{print $1}'`
    local input_ip_seg_3=`echo "${ret}" | sed -n '5p' | awk '{print $1}'`
    local input_ip_seg_4=`echo "${ret}" | sed -n '7p' | awk '{print $1}'`
    local input_ip="${input_ip_seg_1}.${input_ip_seg_2}.${input_ip_seg_3}.${input_ip_seg_4}"
    local input_username=`echo "${ret}" | sed -n '8p'`
    local input_password=`echo "${ret}" | sed -n '9p'`

    debug_print "${0}" "${LINENO}" "get ip_address from dialog: ${input_ip}"
    debug_print "${0}" "${LINENO}" "get username from dialog: ${input_username}"
    
    
    ##################################################
    # check validify
    ##################################################
	
	# ip
    if ! $(is_ip_valid "${input_ip}") ; then
		debug_print "${0}" "${LINENO}" "invalid IP: '${input_ip}'"
        
        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR}"
        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG="${TP_IP_DIVIDER_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT}: ${TP_STRING_IP}<${input_ip}>"
        return
    fi

	# username
	if ! $(is_username_valid "${input_username}") ; then
		debug_print "${0}" "${LINENO}" "invalid username: '${input_username}'"

        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR}"
        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG="${TP_IP_DIVIDER_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT}: ${ERROR_USER_COLUMN_EMPTY}"
        return
	fi
	
	# password
	if ! $(is_password_valid "${input_password}") ; then
		debug_print "${0}" "${LINENO}" "invalid password"

        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR}"
        TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG="${TP_IP_DIVIDER_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT}: password"
		return
	fi
	
	
	##################################################
	# save
	##################################################
    TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP="${input_ip}"
    TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME="${input_username}"
    TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_PASSWORD="${input_password}"
    
    TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_OK}"
    TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG=""
}

